import 'package:admin_desktop/domain/handlers/api_result.dart';
import 'package:admin_desktop/domain/handlers/network_exceptions.dart';
import 'package:admin_desktop/domain/models/response/booking_count_statistic_response.dart';
import 'package:admin_desktop/domain/repository/booking_statistics_repository.dart';
import 'package:admin_desktop/infrastructure/services/app_helpers.dart';
import 'package:admin_desktop/infrastructure/services/local_storage.dart';
import 'package:flutter/material.dart';

import '../../di/dependency_manager.dart';

class BookingStatisticsRepositoryImpl implements BookingsStatisticsFacade {
  @override
  Future<ApiResult<BookingStatisticResponse>> getBookingCountStatistic(
      {required DateTime? from, required DateTime? to}) async {
    final data = {
      'lang': LocalStorage.getLanguage()?.locale ?? "en",
      "date_from": from.toString().substring(0, 10),
      "date_to": to.toString().substring(0, 10),
    };
    try {
      final client = dioHttp.client(requireAuth: true);
      final res = await client
          .get('api/v1/dashboard/${AppHelpers.getUserRole}/booking/reports/statistic', data: data);
      return ApiResult.success(
          data: BookingStatisticResponse.fromMap(res.data));
    } catch (e) {
      debugPrint('==> update booking notes failure: $e');
      return ApiResult.failure(
        error: AppHelpers.errorHandler(e),
        status: NetworkExceptions.getDioStatus(e),
      );
    }
  }
}
